
if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

vehicle = class_REVS_vehicle;

vehicle_driveline_type = enum_driveline_type.one_axle_drive;
vehicle_powertrain_type = enum_powertrain_type.conventional;
vehicle.class = 'standard_car';

vehicle.fuel = engine.fuel;

vehicle.drive_axle1.final_drive.gear_ratio        = 3.23;

vehicle.drive_axle1.final_drive.inertia_kgm2      = 0;    
vehicle.drive_axle1.final_drive.efficiency_norm   = 1.00; % final drive eff included in transmission eff for FWD

vehicle.drive_axle1.brake.inertia_kgm2  = 0;

vehicle.drive_axle1.tire.radius_m       = 0.32;

vehicle.drive_axle1.tire.inertia_kgm2   = 0;

vehicle.chassis.mass_static_kg          = 3625/1.015 * convert.lbm2kg;
vehicle.chassis.mass_dynamic_kg         = vehicle.chassis.mass_static_kg * 1.03;

vehicle_use_abc_roadload = true;
vehicle.chassis.coastdown_A_N           = 132.54;
vehicle.chassis.coastdown_B_Npms        = 1.7125;
vehicle.chassis.coastdown_C_Npms2       = 0.4140;
